const bgColors = ["green", "blue"];

function getRandomBGColor() {
    return bgColors[Math.floor(Math.random() * bgColors.length)];
}

function createOverlay(el, options = {}) {
    const rect = el.getBoundingClientRect();
    if (rect.width === 0 || rect.height === 0) return;

    const overlay = document.createElement("div");
    overlay.className = "content-overlay";
    overlay.style.position = "absolute";
    overlay.style.top = `${window.scrollY + rect.top}px`;
    overlay.style.left = `${window.scrollX + rect.left}px`;
    overlay.style.width = `${rect.width}px`;
    overlay.style.height = `${rect.height}px`;
    overlay.style.backgroundColor = options.color || getRandomBGColor();
    overlay.style.borderRadius = options.rounded ? "999px" : "0";
    overlay.style.border = options.border || "none";
    overlay.style.zIndex = "999999";
    overlay.style.pointerEvents = "none";
    overlay.style.opacity = "1";
    overlay.style.transition = "none";
    overlay.style.transform = "none";

    document.body.appendChild(overlay);
}

function applyOverlays() {
    // Remove old overlays
    document.querySelectorAll('.content-overlay').forEach(o => o.remove());

    // Regular content
    const contentElements = document.querySelectorAll("p, h1, h2, h3, h4, h5, h6, img, span, li, figcaption");
    contentElements.forEach(el => createOverlay(el));

    // Buttons & links
    const uiElements = document.querySelectorAll("button, a");
    uiElements.forEach(el => createOverlay(el, {
        color: "red",
        rounded: true,
        border: "4px solid silver"
    }));

    // Show body when overlays are ready
    document.body.style.visibility = "visible";
    document.documentElement.style.backgroundColor = "white";
    document.body.style.backgroundColor = "white";
}

// Ensure body exists before we hide or work with it
function waitForBodyThenOverlay() {
    if (!document.body) {
        requestAnimationFrame(waitForBodyThenOverlay);
    } else {
        document.body.style.visibility = "hidden"; // Hide body first
        applyOverlays();
    }
}

waitForBodyThenOverlay();

// Reapply overlays on scroll or resize
let scrollTimeout;
["scroll", "resize"].forEach(evt => {
    window.addEventListener(evt, () => {
        clearTimeout(scrollTimeout);
        scrollTimeout = setTimeout(applyOverlays, 100);
    });
});
