
document.addEventListener("click", (event) => {
  const anchor = event.target.closest("a");
  if (!anchor) return; 
  
  // Meld aan background dat er op een link is geklikt.
  chrome.runtime.sendMessage({ type: "link-click" });
});

// Speel drumroll bij scroll; volume staat vast (wordt in offscreen geregeld).
let scrollStopTimeout = null;
let mouseStopTimeout = null;

window.addEventListener("wheel", (event) => {
  // Stuur altijd hetzelfde volume; geen snelheids-afhankelijke schaal.
  // Hiermee weet background/offscreen dat er gescrolled wordt.
  chrome.runtime.sendMessage({ type: "scroll-sound" });

  // Stuur een stop-signaal als er even niet wordt gescrolled
  if (scrollStopTimeout) {
    clearTimeout(scrollStopTimeout);
  }
  scrollStopTimeout = setTimeout(() => {
    // Geef door dat het scrollen is gestopt zodat het geluid kan stoppen.
    chrome.runtime.sendMessage({ type: "scroll-stop" });
  }, 200);
}, { passive: true });

// (zoekgeluid verwijderd)

// Speel tom-geluid tijdens muisbeweging
window.addEventListener("mousemove", () => {
  chrome.runtime.sendMessage({ type: "mouse-move" });
  if (mouseStopTimeout) {
    clearTimeout(mouseStopTimeout);
  }
  mouseStopTimeout = setTimeout(() => {
    chrome.runtime.sendMessage({ type: "mouse-stop" });
  }, 200);
}, { passive: true });

// Toon heaven-afbeelding wanneer gevraagd
function showHeavenOverlay() {
  const existing = document.getElementById("heaven-overlay");
  if (existing) {
    existing.remove();
  }

  const overlay = document.createElement("div");
  overlay.id = "heaven-overlay";
  overlay.style.position = "fixed";
  overlay.style.inset = "0";
  overlay.style.display = "grid";
  overlay.style.placeItems = "center";
  overlay.style.pointerEvents = "none";
  overlay.style.zIndex = "2147483647";

  const img = document.createElement("img");
  img.src = chrome.runtime.getURL("images/heaven.jpg");
  img.alt = "heaven";
  img.style.width = "220px";
  img.style.height = "220px";
  img.style.objectFit = "contain";

  overlay.appendChild(img);
  document.body.appendChild(overlay);

  setTimeout(() => {
    overlay.remove();
  }, 4000);
}

chrome.runtime.onMessage.addListener((msg) => {
  if (msg?.type === "show-heaven") {
    showHeavenOverlay();
  }
});
